/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.integrator;

import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWOperationDefinition;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.base.VWXMLWrapper;
import filenet.vw.integrator.IVWComponentConfiguration;
import filenet.vw.toolkit.admin.VWConfigQueueNode;
import filenet.vw.toolkit.admin.VWConfigRegionNode;
import filenet.vw.toolkit.admin.property.integrator.IVWAdaptorInfoListener;
import filenet.vw.toolkit.utils.VWStringUtils;
import javax.swing.event.EventListenerList;

public class VWAdaptorInfo {
    private VWQueueDefinition m_vwQueueDef = null;
    private IVWComponentConfiguration m_componentConfigClass = null;
    private VWXMLWrapper m_componentDescXMLWrapper = null;
    private EventListenerList m_listenerList = null;

    public VWAdaptorInfo() {
    }

    public VWAdaptorInfo(VWQueueDefinition vwQueueDef) {
        this.m_vwQueueDef = vwQueueDef;
    }

    public VWAdaptorInfo(String componentDescriptor) throws Exception {
        this.m_componentDescXMLWrapper = new VWXMLWrapper(componentDescriptor);
    }

    public void addPropertyChangeListener(IVWAdaptorInfoListener listener) {
        if (this.m_listenerList == null) {
            this.m_listenerList = new EventListenerList();
        }
        this.m_listenerList.add(IVWAdaptorInfoListener.class, listener);
    }

    public void removePropertyChangeListener(IVWAdaptorInfoListener listener) {
        if (this.m_listenerList != null) {
            this.m_listenerList.remove(IVWAdaptorInfoListener.class, listener);
        }
    }

    public VWConfigQueueNode createQueue(String name, String description, VWConfigRegionNode regionNode) throws Exception {
        if (this.m_componentDescXMLWrapper != null) {
            VWQueueDefinition queueDef = regionNode.getSystemConfiguration().createQueueDefinition(name, 1);
            queueDef.setIsConnectorQueue(true);
            queueDef.setServerId(0);
            if (description != null) {
                queueDef.setDescription(description);
            }
            VWAttributeInfo attributeInfo = queueDef.getAttributeInfo();
            this.m_componentDescXMLWrapper.setNodeValue(this.m_componentDescXMLWrapper.getRootNode(), "name", name);
            if (description != null && description.length() > 0) {
                this.m_componentDescXMLWrapper.setNodeValue(this.m_componentDescXMLWrapper.getRootNode(), "description", description);
            }
            attributeInfo.setFieldValue("F_ComponentDescriptor", this.m_componentDescXMLWrapper.toString());
            queueDef.setAttributeInfo(attributeInfo);
            return new VWConfigQueueNode(regionNode.getSessionInfo(), queueDef, regionNode.getServiceName(), regionNode.getRegionID(), 0, regionNode.getSystemConfiguration());
        }
        return null;
    }

    public void setDescription(String description) throws Exception {
        VWXMLWrapper xmlWrapper = this.getComponentDescriptor();
        if (xmlWrapper != null) {
            xmlWrapper.setNodeValue(xmlWrapper.getRootNode(), "description", description);
        }
    }

    public VWQueueDefinition getQueueDefinition() {
        return this.m_vwQueueDef;
    }

    public IVWComponentConfiguration getComponentConfigurationClass() {
        return this.m_componentConfigClass;
    }

    public void setComponentConfigurationClass(IVWComponentConfiguration componentConfigClass) {
        this.m_componentConfigClass = componentConfigClass;
    }

    public String getComponentDescriptorString() throws Exception {
        VWXMLWrapper componentDescriptorWrapper = this.getComponentDescriptor();
        if (componentDescriptorWrapper != null) {
            return componentDescriptorWrapper.toString();
        }
        return null;
    }

    public VWXMLWrapper getComponentDescriptor() throws Exception {
        if (this.m_componentDescXMLWrapper == null) {
            String document;
            if (this.m_vwQueueDef == null) {
                return null;
            }
            VWAttributeInfo attributeInfo = this.m_vwQueueDef.getAttributeInfo();
            if (attributeInfo != null && (document = (String)attributeInfo.getFieldValue("F_ComponentDescriptor")) != null && document.length() > 0) {
                this.m_componentDescXMLWrapper = new VWXMLWrapper(document);
            }
        }
        return this.m_componentDescXMLWrapper;
    }

    public void setComponentDescriptor(String xmlStream) throws Exception {
        VWOperationDefinition[] operationDefs;
        boolean bRemoveOperations = false;
        VWXMLWrapper newXMLWrapper = null;
        if (this.m_componentDescXMLWrapper != null && this.m_vwQueueDef != null) {
            String oldTargetClass = VWXMLWrapper.getNodeValue(this.m_componentDescXMLWrapper.getRootNode(), "target_class");
            if (oldTargetClass != null && oldTargetClass.length() > 0) {
                newXMLWrapper = new VWXMLWrapper(xmlStream);
                String newTargetClass = VWXMLWrapper.getNodeValue(newXMLWrapper.getRootNode(), "target_class");
                if (newTargetClass != null && newTargetClass.length() > 0 && VWStringUtils.compare(oldTargetClass, newTargetClass) != 0) {
                    bRemoveOperations = true;
                }
            }
        }
        this.m_componentDescXMLWrapper = newXMLWrapper != null ? newXMLWrapper : new VWXMLWrapper(xmlStream);
        if (this.m_vwQueueDef == null) {
            return;
        }
        this.m_componentDescXMLWrapper.setNodeValue(this.m_componentDescXMLWrapper.getRootNode(), "name", this.m_vwQueueDef.getName());
        this.save();
        if (bRemoveOperations && (operationDefs = this.m_vwQueueDef.getOperations()) != null && operationDefs.length > 0) {
            for (int i = operationDefs.length - 1; i >= 0; --i) {
                this.m_vwQueueDef.deleteOperation(operationDefs[i].getName());
            }
        }
        this.notifyListeners();
    }

    public void save() throws Exception {
        if (this.m_vwQueueDef == null || this.m_componentDescXMLWrapper == null) {
            return;
        }
        VWAttributeInfo attributeInfo = this.m_vwQueueDef.getAttributeInfo();
        if (attributeInfo != null) {
            attributeInfo.setFieldValue("F_ComponentDescriptor", this.m_componentDescXMLWrapper.toString());
            this.m_vwQueueDef.setAttributeInfo(attributeInfo);
        }
    }

    public void releaseResources() {
        this.m_vwQueueDef = null;
        this.m_componentConfigClass = null;
        this.m_componentDescXMLWrapper = null;
        if (this.m_listenerList != null) {
            Object[] listeners = this.m_listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                this.m_listenerList.remove(IVWAdaptorInfoListener.class, (IVWAdaptorInfoListener)listeners[i + 1]);
                listeners[i] = null;
                listeners[i + 1] = null;
            }
            this.m_listenerList = null;
        }
    }

    private void notifyListeners() {
        if (this.m_listenerList != null) {
            Object[] listeners = this.m_listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != IVWAdaptorInfoListener.class) continue;
                ((IVWAdaptorInfoListener)listeners[i + 1]).adaptorInfoChanged();
            }
        }
    }
}

